<?php


if (!defined('ABSPATH')) {
    exit;
}


DigitsOneClickForm::instance();

final class DigitsOneClickForm
{
    protected static $_instance = null;
    private $remove_key = false;

    public function __construct()
    {
        add_action('digits_render_custom_form', [$this, 'render'], 20);
        add_action('digits_login_user_not_found', [$this, 'init_signup']);
    }


    /**
     *  Constructor.
     */
    public static function instance()
    {
        if (is_null(self::$_instance)) {
            self::$_instance = new self();
        }
        return self::$_instance;
    }


    public function render($details)
    {
        $details['login_title'] = esc_attr__('Login / Register', 'digits');
        $details['users_can_register'] = 0;

        $extra_data = '';
        if (!empty($details['extra_data'])) {
            $extra_data .= $details['extra_data'];
        }
        $extra_data .= '<input type="hidden" name="show_force_title" value="1">';
        $details['extra_data'] = $extra_data;
        if (empty($details['disable_login'])) {
            digits_render_login_form($details);
        }
        if (empty($details['disable_forgot'])) {
            digits_render_forgot_form($details);
        }
        digits_select2();
    }

    public function init_signup($action_type)
    {
        if (digoneclickls_hideloginitems() == 0) {
            return;
        }
        $_REQUEST['type'] = 'register';

        if ($action_type == 'phone') {

            $countryCode = $_REQUEST['login_digt_countrycode'];
            if (empty($countryCode)) {
                $countryCode = $_REQUEST['digt_countrycode'];
                if (empty($countryCode)) {
                    $countryCode = $_REQUEST['dig_countrycodec'];
                }
            }
            $_REQUEST['digt_countrycode'] = $countryCode;


            $_REQUEST['phone'] = $_REQUEST['digits_phone'];
            $this->remove_key = 'dig_cs_mobilenumber';
        } else {
            $_REQUEST['email'] = $_REQUEST['digits_email'];
            $this->remove_key = 'dig_cs_email';
        }
        $_REQUEST['is_digits_optional_data'] = 1;
        add_filter('digits_signup_render_fields_list', [$this, 'filter_fields_list']);
        add_filter('digits_signup_check_empty_field', [$this, 'check_empty_field']);

        digits_forms_ajax();
    }
    public function check_empty_field($check){
        return true;
    }

    public function filter_fields_list($fields)
    {
        if (!empty($this->remove_key)) {
            $fields = $this->remove_field($fields, $this->remove_key);
        }
        return $fields;
    }

    public function remove_field($list, $field)
    {
        $key = array_search($field, $list, true);
        if ($key !== false) {
            unset($list[$key]);
        }
        return $list;
    }
}


