<?php
/**
 * PPOM Fields Manager Class
 **/

/*
**========== Direct access not allowed ===========
*/
if ( ! defined( 'ABSPATH' ) ) {
	die( 'Not Allowed' );
}


class PPOM_Fields_Meta {

	private static $ins;


	function __construct() {

		add_action( 'admin_enqueue_scripts', array( $this, 'load_script' ) );
	}


	public static function get_instance() {
		// create a new object if it doesn't exist.
		is_null( self::$ins ) && self::$ins = new self();

		return self::$ins;
	}


	/*
	**============ Load all scripts ===========
	*/
	function load_script( $hook ) {

		if ( ! isset( $_GET['page'] ) || $_GET['page'] != 'ppom' ) {
			return;
		}

		$suffix = defined( 'SCRIPT_DEBUG' ) && SCRIPT_DEBUG ? '' : '.min';

		// Preloader script
		wp_enqueue_script( 'ppom-perload', PPOM_URL . '/js/admin/pre-load.js', array( 'jquery' ), PPOM_VERSION, true );

		// Bootstrap Files
		wp_enqueue_style( 'ppom-bs', PPOM_URL . '/css/bootstrap/bootstrap.css' );
		wp_enqueue_script( 'ppom-bs', PPOM_URL . '/js/bootstrap/bootstrap.min.js' );

		if( isset($_GET['view']) && $_GET['view'] === 'changelog' ) {
			wp_enqueue_script( 'ppom-jq-ui-ac', PPOM_URL . '/backend/assets/jquery-ui-accordion/jquery-ui.min.js', array('jquery'), '1.13.2', false );
			wp_enqueue_style( 'ppom-jq-ui-ac', PPOM_URL . '/backend/assets/jquery-ui-accordion/jquery-ui.min.css', array(), '1.13.2' );
		}

		// Bulk Quantity Addon JS File
		wp_enqueue_script( 'ppom-bulkquantity', PPOM_URL . '/js/admin//ppom-bulkquantity.js', array( 'jquery' ), PPOM_VERSION, true );
		wp_localize_script( 'ppom-bulkquantity', 'ppom_bq', [
			'i18n'=>[
				'validation'=>[
					'end_bigger_than_start' => esc_html__('The end value of the range must be greater than the start value. (range: {range})', 'woocommerce-product-addon'),
					'start_cannot_be_equal_with_end' => esc_html__('The start value cannot be equal to the end value. (range: {range})', 'woocommerce-product-addon'),
					'range_intersection' => esc_html__( 'Values in two ranges intersect. Every range of numbers should be covered by only one range. Intersects ranges: {range1} AND {range2}', 'woocommerce-product-addon' ),
					'invalid_pattern' => esc_html__( 'Range format is invalid. (range: {range})', 'woocommerce-product-addon' )
				]
			]
		] );

		wp_enqueue_script( 'ppom-inputmask', PPOM_URL . '/js/inputmask/jquery.inputmask.min.js', array( 'jquery' ), '5.0.6', true );

		// Popup
		wp_enqueue_script( 'ppom-popup', PPOM_URL . '/js/popup.js', [], PPOM_VERSION, true );

		// PPOM Meta Table File
		wp_enqueue_script( 'ppom-meta-table', PPOM_URL . '/js/admin/ppom-meta-table.js', array( 'jquery', 'ppom-popup' ), PPOM_VERSION, true );

		// Font-awesome File
		if ( ppom_load_fontawesome() ) {
			wp_enqueue_style( 'ppom-fontawsome', PPOM_URL . '/css/font-awesome/css/font-awesome.min.css' );
		}

		// Select2 Files
		wp_enqueue_style( 'ppom-select2', PPOM_URL . '/css/select2.css' );
		wp_enqueue_script( 'ppom-select2', PPOM_URL . '/js/select2.js', array( 'jquery' ), PPOM_VERSION, true );

		if ( ( isset( $_GET['do_meta'] ) && 'edit' === $_GET['do_meta'] ) || ( isset( $_GET['action'] ) && 'new' === $_GET['action'] ) ) {

			// CSS Code Editor Files
			wp_enqueue_style( 'ppom-codemirror-theme', PPOM_URL . '/css/codemirror-theme.css' );
			$css_code_editor = wp_enqueue_code_editor( array( 'type' => 'text/css' ) );
			$legacy_user     = ppom_is_legacy_user();
			// ppom_pa($css_code_editor); exit;
			if ( false !== $css_code_editor ) {
				$css_code_editor['codemirror']['autoRefresh'] = true;
				if ( $legacy_user ) {
					$css_code_editor['codemirror']['readOnly'] = 'nocursor';
				}
				$css_code_editor['codemirror']['theme'] = 'darcula';
				wp_add_inline_script(
					'code-editor',
					sprintf(
						'jQuery( function() { wp.codeEditor.initialize( "ppom-css-editor", %s ); } );',
						wp_json_encode( $css_code_editor )
					)
				);
			}

			// Js Code Editor Files
			$js_code_editor = wp_enqueue_code_editor( array( 'type' => 'text/javascript' ) );
			if ( false !== $js_code_editor ) {
				$js_code_editor['codemirror']['autoRefresh'] = true;
				if ( $legacy_user ) {
					$js_code_editor['codemirror']['readOnly'] = 'nocursor';
				}
				$js_code_editor['codemirror']['theme'] = 'darcula';
				wp_add_inline_script(
					'code-editor',
					sprintf(
						'jQuery( function() { wp.codeEditor.initialize( "ppom-js-editor", %s ); } );',
						wp_json_encode( $js_code_editor )
					)
				);
			}
		}

		// Tabletojson JS File
		wp_enqueue_script( 'ppom-tabletojson', PPOM_URL . '/js/admin/jquery.tabletojson.min.js', array( 'jquery' ), PPOM_VERSION, true );

		// Datatable Files
		wp_enqueue_style( 'ppom-datatables', PPOM_URL . '/js/datatable/datatables.min.css' );
		wp_enqueue_script( 'ppom-datatables', PPOM_URL . '/js/datatable/jquery.dataTables.min.js', array( 'jquery' ), PPOM_VERSION, true );

		// Description Tooltips JS File
		wp_enqueue_script( 'ppom-tooltip', PPOM_URL . '/js/ppom-tooltip.js', array( 'jquery' ), PPOM_VERSION, true );
		wp_register_script( 'serializejson', PPOM_URL . '/js/admin/serializejson.js', array( 'jquery' ), '2.8.1');

		// Add the color picker css file
		wp_enqueue_style( 'wp-color-picker' );

		// PPOM Admin Files
		wp_enqueue_style( 'ppom-field', PPOM_URL . '/css/ppom-admin.css', '', PPOM_VERSION );
		wp_enqueue_script(
			'ppom-field',
			PPOM_URL . '/js/admin/ppom-admin.js',
			array(
				'ppom-popup',
				'ppom-select2',
				'ppom-tabletojson',
				'ppom-datatables',
				'serializejson',
				'ppom-tooltip',
				'jquery-ui-core',
				'jquery-ui-sortable',
				'ppom-perload',
				'wp-color-picker',
			),
			PPOM_VERSION,
			true 
		);

		wp_enqueue_media();

		$ppom_admin_meta = array(
			'plugin_admin_page' => admin_url( 'admin.php?page=ppom' ),
			'loader'            => PPOM_URL . '/images/loading.gif',
			'ppomProActivated'=>ppom_pro_is_installed() && PPOM()->is_license_of_type( 'pro' ) ? 'yes' : 'no',
			'i18n' => [
				'addGroupUrl' => esc_url( add_query_arg( array( 'action' => 'new' ) ) ),
				'addGroupLabel'=>esc_html__( 'Add New Group', 'woocommerce-product-addon' ),
				'bulkActionsLabel'=>esc_html__( 'Bulk Actions', 'woocommerce-product-addon' ),
				'deleteLabel'=>esc_html__( 'Delete', 'woocommerce-product-addon' ),
				'exportLabel'=>esc_html__( 'Export', 'woocommerce-product-addon' ),
				'exportLockedLabel'=> esc_html__( 'Export', 'woocommerce-product-addon' ) . ' (' . esc_html__( 'PRO', 'woocommerce-product-addon' ) . ')',
				'importLabel'=>esc_html__( 'Import Field Groups ', 'woocommerce-product-addon' ),
				'freemiumCFRContent' => \PPOM_Freemium::get_instance()->get_freemium_cfr_content(),
				'freemiumCFRTab' => \PPOM_Freemium::TAB_KEY_FREEMIUM_CFR,
				'popup' => [
					'confirmTitle' => __( 'Are you sure?', 'woocommerce-product-addon' ),
					'confirmationBtn' => __( 'Confirm', 'woocommerce-product-addon' ),
					'cancelBtn' => __( 'Cancel', 'woocommerce-product-addon' ),
					'finishTitle' => __( 'Done', 'woocommerce-product-addon' ),
					'errorTitle' => __( 'Error', 'woocommerce-product-addon' ),
					'checkFieldTitle' => __( 'Please at least check one field!', 'woocommerce-product-addon' ),

				],
				'errorOccurred' => __( 'An error occurred. Please try again.', 'woocommerce-product-addon' ),
				'yes' => __( 'Yes', 'woocommerce-product-addon' ),
				'no' => __( 'No', 'woocommerce-product-addon' ),
				'updatedField' => __( 'Update Field', 'woocommerce-product-addon' ),
				'pricePlaceholder' => __( 'Price (fix or %)', 'woocommerce-product-addon' ),
				'choseFile' => __( 'Choose File', 'woocommerce-product-addon' ),
				'upload' => __( 'Upload', 'woocommerce-product-addon' ),
				'stock' => __( 'Stock', 'woocommerce-product-addon' ),
				'metaIds' => __( 'Meta IDs', 'woocommerce-product-addon' ),
				'cannotRemoveMoreOption' => __( 'Cannot Remove More Option', 'woocommerce-product-addon' ),
				'dataNameRequired' => __( 'Data Name must be required', 'woocommerce-product-addon' ),
				'dataNameExists' => __( 'Data Name already exists', 'woocommerce-product-addon' )
			]
		);

		// localize ppom_vars
		wp_localize_script( 'ppom-field', 'ppom_vars', $ppom_admin_meta );
		wp_localize_script( 'ppom-meta-table', 'ppom_vars', $ppom_admin_meta );

		$action    = isset( $_GET['action'] ) ? sanitize_text_field( $_GET['action'] ) : '';
		$page_slug = 'fields';

		if ( 'new' === $action ) {
			$page_slug = 'new-field';
		} elseif( 'edit' === $action ) {
			$page_slug = 'edit-field';
		}

		do_action( 'themeisle_internal_page', PPOM_PRODUCT_SLUG, $page_slug );
	}


	/*
	**============ Render all fields ===========
	*/
	function render_field_settings() {
		// ppom_pa(PPOM() -> inputs);

		$html  = '';
		$html .= '<div id="ppom-fields-wrapper">';
		foreach ( PPOM()->inputs as $fields_type => $meta ) {

			$field_title = isset( $meta->title ) ? $meta->title : null;
			$field_desc  = isset( $meta->desc ) ? $meta->desc : null;
			$settings    = isset( $meta->settings ) ? $meta->settings : array();

			$settings = $this->update_html_classes( $settings );

			// new model
			$html .= '<div class="ppom-modal-box ppom-slider ppom-field-' . esc_attr( $fields_type ) . '">';
			$html .= '<header>';
			$html .= '<h3>' . esc_html( $field_title ) . '</h3>';
			$html .= '</header>';
			$html .= '<div class="ppom-modal-body">';

			$html .= $this->render_field_meta( $settings, $fields_type );

			$html .= '</div>';
			$html .= '<footer>';
			$html .= '<span class="ppom-req-field-id"></span>';
			$html .= '<button type="button" class="btn btn-default ppom-close-checker ppom-close-fields ppom-js-modal-close" style="margin-right: 5px;">' . esc_html__( 'close', 'woocommerce-product-addon' ) . '</button>';
			$html .= '<button type="button" class="btn btn-primary ppom-field-checker ppom-add-field" data-field-type="' . esc_attr( $field_title ) . '">' . esc_html__( 'Add Field', 'woocommerce-product-addon' ) . '</button>';
			$html .= '</footer>';
			$html .= '</div>';
		}

		$html .= '</div>';
		echo $html;
	}

	/*
	**============ Render all fields meta ===========
	*/
	function render_field_meta( $field_meta, $fields_type, $field_index = '', $save_meta = '' ) {
		// ppom_pa($save_meta);
		$html  = '';
		$html .= '<div data-table-id="' . esc_attr( $fields_type ) . '" class="row ppom-tabs ppom-fields-actions" data-field-no="' . esc_attr( $field_index ) . '">';
		$html .= '<input type="hidden" name="ppom[' . $field_index . '][type]" value="' . $fields_type . '" class="ppom-meta-field" data-metatype="type">';
		$html .= '<div class="col-md-12 ppom-tabs-header">';


		$ppom_field_tabs = $this->ppom_fields_tabs( $fields_type );
		foreach ( $ppom_field_tabs as $tab_index => $tab_meta ) {

			$tab_label   = isset( $tab_meta['label'] ) ? $tab_meta['label'] : '';
			$tab_class   = isset( $tab_meta['class'] ) ? $tab_meta['class'] : '';
			$tab_depend  = isset( $tab_meta['field_depend'] ) ? $tab_meta['field_depend'] : array();
			$not_allowed = isset( $tab_meta['not_allowed'] ) ? $tab_meta['not_allowed'] : array();
			$tab_class   = implode( ' ', $tab_class );

			if ( in_array( 'all', $tab_depend ) && ! in_array( $fields_type, $not_allowed ) ) {

				$html .= '<label for="' . esc_attr( $tab_index ) . '" id="' . esc_attr( $tab_index ) . '" class="' . esc_attr( $tab_class ) . '">' . $tab_label . '</label>';
			} elseif ( in_array( $fields_type, $tab_depend ) ) {

				$html .= '<label for="' . esc_attr( $tab_index ) . '" id="' . esc_attr( $tab_index ) . '" class="' . esc_attr( $tab_class ) . '">' . $tab_label . '</label>';
			}
		}


		$html .= '</div>';
		if ( $field_meta ) {

			foreach ( $field_meta as $fields_meta_key => $meta ) {

				$title  = isset( $meta['title'] ) ? $meta['title'] : '';
				$desc   = isset( $meta['desc'] ) ? $meta['desc'] : '';
				$type   = isset( $meta['type'] ) ? $meta['type'] : '';
				$link   = isset( $meta['link'] ) ? $meta['link'] : '';
				$learn_more = isset( $meta['learn_more'] ) ? $meta['learn_more'] : array();
				$values = isset( $save_meta[ $fields_meta_key ] ) ? $save_meta[ $fields_meta_key ] : '';

				$default_value = isset( $meta ['default'] ) ? $meta ['default'] : '';
				// ppom_pa($meta);

				if ( empty( $values ) ) {
					$values = $default_value;
				}

				$input_wrapper_classes = isset( $meta['col_classes'] ) ? $meta['col_classes'] : array();
				// $input_wrapper_classes = array('col-md-6', 'col-sm-6');

				if ( empty( $input_wrapper_classes ) ) {
					$input_wrapper_classes = array( 'col-md-6', 'col-sm-12' );
				}

				$panel_classes   = isset( $meta['tabs_class'] ) ? $meta['tabs_class'] : array_merge( $input_wrapper_classes, array( 'ppom_handle_fields_tab' ) );
				$panel_classes[] = 'ppom-control-all-fields-tabs';

				if ( $type == 'checkbox' ) {
					$panel_classes[] = 'ppom-checkboxe-style';
				}
				if ( ! empty( $panel_classes ) ) {
					$panel_classes = implode( ' ', $panel_classes );
				}

				$html .= '<div data-meta-id="' . esc_attr( $fields_meta_key ) . '" class="' . esc_attr( $panel_classes ) . '">';
				$html .= '<div class="form-group">';

				$html .= '<label>' . esc_html( $title ) . '';
				if ( ! empty( $learn_more['link'] ) ) {
					$html .= '. <a href="' . esc_url( $learn_more['link'] ) . '" class="ppom-repeater-learn-more" target="_blank">' . $learn_more['text'] .  '<span class="dashicons dashicons-external"></span></a>';
				} else if( ! empty( $desc ) ) {
					$html .= '<span class="ppom-helper-icon" data-ppom-tooltip="ppom_tooltip" title="' . esc_html( $desc ) . '">';
					$html .= '<i class="dashicons dashicons-editor-help"></i>';
				}
				$html .= '</span>' . $link . '';
				$html .= '</label>';
				$html .= $this->render_all_input_types( $fields_meta_key, $meta, $fields_type, $field_index, $values );

				$html .= '</div>';
				$html .= '</div>';

			}
		}

		$html .= '</div>';

		return $html;
	}


	/*
	* this function is rendring input field for settings
	*/
	function render_all_input_types( $name, $data, $fields_type, $field_index, $values ) {
		// ppom_pa($data);

		$type = ( isset( $data ['type'] ) ? $data ['type'] : '' );

		$options      = ( isset( $data ['options'] ) ? $data ['options'] : '' );
		$placeholders = isset( $data['placeholders'] ) ? $data['placeholders'] : '';

		$existing_name = 'name="ppom[' . esc_attr( $field_index ) . '][' . esc_attr( $name ) . ']"';

		$plugin_meta = ppom_get_plugin_meta();
		$html_input  = '';

		if ( ! is_array( $values ) ) {
			$values        = stripslashes( $values );
			$decode_values = json_decode( $values, true );
			$values        = is_array( $decode_values ) ? $decode_values : $values;
		}

		switch ( $type ) {

			case 'number':
			case 'text':
				// ppom_pa($values);
				$html_input .= '<input data-metatype="' . esc_attr( $name ) . '" type="' . esc_attr( $type ) . '"  value="' . esc_html( $values ) . '" class="form-control ppom-meta-field"';

				if ( $field_index != '' ) {

					$html_input .= $existing_name;
				}

				$html_input .= '>';
				break;

			case 'color':
				$html_input .= '<div class="ppom-color-picker-cloner">';
				$html_input .= '<input data-alpha-enabled="true" data-metatype="' . esc_attr( $name ) . '" type="text"  value="' . esc_html( $values ) . '" class="form-control ppom-meta-field ppom-color-picker-init"';

				if ( $field_index != '' ) {

					$html_input .= $existing_name;
				}

				$html_input .= '>';
				$html_input .= '</div>';
				break;

			case 'textarea':
				$html_input .= '<textarea data-metatype="' . esc_attr( $name ) . '" class="form-control ppom-meta-field ppom-adjust-box-height"';

				if ( $field_index != '' ) {

					$html_input .= $existing_name;
				}

				$html_input .= '>' . esc_html( $values ) . '</textarea>';

				break;

			case 'select':
				$html_input .= '<select id="' . $name . '" data-metatype="' . esc_attr( $name ) . '" class="form-control ppom-meta-field"';

				if ( $field_index != '' ) {

					$html_input .= $existing_name;
				}

				$html_input .= '>';

				foreach ( $options as $key => $val ) {
					$selected    = ( $key == $values ) ? 'selected="selected"' : '';
					$html_input .= '<option value="' . $key . '" ' . $selected . '>' . esc_html( $val ) . '</option>';
				}
				$html_input .= '</select>';

				break;

			case 'paired':
				$plc_option = ( ! empty( $placeholders ) ) ? $placeholders[0] : __( 'Option', 'woocommerce-product-addon' );
				$plc_price  = ( ! empty( $placeholders ) ) ? $placeholders[1] : __( 'Price (optional)', 'woocommerce-product-addon' );

				$weight_unit  = get_option( 'woocommerce_weight_unit' );
				$plc_discount = ( isset( $placeholders[2] ) && ! empty( $placeholders ) ) ? $placeholders[2] : __( 'Discount', 'woocommerce-product-addon' );
				$plc_tooltip  = ( isset( $placeholders[3] ) && ! empty( $placeholders ) ) ? $placeholders[3] : __( 'Tooltip', 'woocommerce-product-addon' );
				$plc_weight   = ( isset( $placeholders[4] ) && ! empty( $placeholders ) ) ? $placeholders[4] : sprintf(
					// translators: $s: the weight unit.
					__( 'Weight-%s', 'woocommerce-product-addon' ) . ' (' . __( 'PRO only', 'woocommerce-product-addon' ) . ')',
					$weight_unit
				);
				$plc_stock    = ( isset( $placeholders[5] ) && ! empty( $placeholders ) ) ? $placeholders[5] : __( 'Stock', 'woocommerce-product-addon' ) . ' (' . __( 'PRO only', 'woocommerce-product-addon' ) . ')';

				if ( ppom_pro_is_installed() ) {

					$plc_discount = ( isset( $placeholders[2] ) && ! empty( $placeholders ) ) ? $placeholders[2] : __( 'Discount', 'woocommerce-product-addon' );
					$plc_tooltip  = ( isset( $placeholders[3] ) && ! empty( $placeholders ) ) ? $placeholders[3] : __( 'Tooltip', 'woocommerce-product-addon' );
					$plc_weight   = ( isset( $placeholders[4] ) && ! empty( $placeholders ) ) ? $placeholders[4] : sprintf(
						// translators: $s: the weight unit.
						__( 'Weight-%s (optional)', 'woocommerce-product-addon' ),
						$weight_unit
					);
					$plc_stock    = ( isset( $placeholders[5] ) && ! empty( $placeholders ) ) ? $placeholders[5] : __( 'Stock (optional)', 'woocommerce-product-addon' );
				}

				$plc_id = ( isset( $placeholders[3] ) && ! empty( $placeholders ) ) ? $placeholders[3] : __( 'Unique Option ID)', 'woocommerce-product-addon' );

				$opt_index0  = 1;
				$html_input .= '<ul class="ppom-options-container ppom-options-sortable">';

				if ( $values ) {
					// ppom_pa($values);
					$last_array_id = max( array_keys( $values ) );

					foreach ( $values as $opt_index => $option ) {

						$discount = isset( $option['discount'] ) ? $option['discount'] : '';
						$tooltip  = isset( $option['tooltip'] ) ? $option['tooltip'] : '';
						$weight   = isset( $option['weight'] ) ? $option['weight'] : '';
						$stock    = isset( $option['stock'] ) ? $option['stock'] : '';

						$option_id   = ppom_get_option_id( $option );
						$html_input .= '<li class="data-options ppom-sortable-handle" style="display: flex;" data-condition-type="simple_options">';
						$html_input .= '<span class="dashicons dashicons-move"></span>';
						$html_input .= '<input type="text" class="option-title form-control ppom-option-keys" name="ppom[' . esc_attr( $field_index ) . '][options][' . esc_attr( $opt_index ) . '][option]" value="' . esc_attr( stripslashes( $option['option'] ) ) . '" placeholder="' . $plc_option . '" data-metatype="option" data-opt-index="' . esc_attr( $opt_index ) . '">';
						$html_input .= '<input type="text" class="option-price form-control ppom-option-keys" name="ppom[' . esc_attr( $field_index ) . '][options][' . esc_attr( $opt_index ) . '][price]" value="' . esc_attr( $option['price'] ) . '" placeholder="' . $plc_price . '" data-metatype="price" data-opt-index="' . esc_attr( $opt_index ) . '">';

						if ( $fields_type === 'checkbox' ) {
							$html_input .= '<input type="text" class="option-discount form-control ppom-option-keys" name="ppom[' . esc_attr( $field_index ) . '][options][' . esc_attr( $opt_index ) . '][discount]" value="' . esc_attr( $discount ) . '" placeholder="' . $plc_discount . '" data-metatype="discount" data-opt-index="' . esc_attr( $opt_index ) . '">';
							$html_input .= '<input type="text" class="option-tooltip form-control ppom-option-keys" name="ppom[' . esc_attr( $field_index ) . '][options][' . esc_attr( $opt_index ) . '][tooltip]" value="' . esc_attr( $tooltip ) . '" placeholder="' . $plc_tooltip . '" data-metatype="tooltip" data-opt-index="' . esc_attr( $opt_index ) . '">';
						}

						$html_input .= '<input type="text" class="option-weight form-control ppom-option-keys" name="ppom[' . esc_attr( $field_index ) . '][options][' . esc_attr( $opt_index ) . '][weight]" value="' . esc_attr( $weight ) . '" placeholder="' . $plc_weight . '" data-metatype="weight" data-opt-index="' . esc_attr( $opt_index ) . '">';
						$html_input .= '<input type="text" class="option-stock form-control ppom-option-keys" name="ppom[' . esc_attr( $field_index ) . '][options][' . esc_attr( $opt_index ) . '][stock]" value="' . esc_attr( $stock ) . '" placeholder="' . $plc_stock . '" data-metatype="stock" data-opt-index="' . esc_attr( $opt_index ) . '">';
						$html_input .= '<input type="text" class="option-id form-control ppom-option-keys" name="ppom[' . esc_attr( $field_index ) . '][options][' . esc_attr( $opt_index ) . '][id]" value="' . esc_attr( $option_id ) . '" placeholder="' . $plc_id . '" data-metatype="id" data-opt-index="' . esc_attr( $opt_index ) . '">';

						$html_input .= '<button class="btn btn-success ppom-add-option" data-option-type="paired"><i class="fa fa-plus" aria-hidden="true"></i></button>';
						$html_input .= '<button class="btn btn-danger ppom-remove-option"><i class="fa fa-minus" aria-hidden="true"></i></button>';

						$html_input .= '</li>';

						$opt_index0 = $last_array_id;
						$opt_index0 ++;

					}
				} else {
					$html_input .= '<li class="data-options" style="display: flex;" data-condition-type="simple_options">';
					$html_input .= '<span class="dashicons dashicons-move"></span>';
					$html_input .= '<input type="text" class="option-title form-control ppom-option-keys" placeholder="' . $plc_option . '" data-metatype="option">';
					$html_input .= '<input type="text" class="option-price form-control ppom-option-keys" placeholder="' . $plc_price . '" data-metatype="price">';

					if ( $fields_type === 'checkbox' ) {
						$html_input .= '<input type="text" class="option-discount form-control ppom-option-keys" placeholder="' . $plc_discount . '" data-metatype="discount">';
						$html_input .= '<input type="text" class="option-tooltip form-control ppom-option-keys" placeholder="' . $plc_tooltip . '" data-metatype="tooltip">';
					}

					$html_input .= '<input type="text" class="option-weight form-control ppom-option-keys" placeholder="' . $plc_weight . '" data-metatype="weight">';
					$html_input .= '<input type="text" class="option-stock form-control ppom-option-keys" placeholder="' . $plc_stock . '" data-metatype="stock">';

					$html_input .= '<input type="text" class="option-id form-control ppom-option-keys" placeholder="' . $plc_id . '" data-metatype="id">';

					$html_input .= '<button class="btn btn-success ppom-add-option" data-option-type="paired"><i class="fa fa-plus" aria-hidden="true"></i></button>';
					$html_input .= '<button class="btn btn-danger ppom-remove-option"><i class="fa fa-minus" aria-hidden="true"></i></button>';

					$html_input .= '</li>';
				}
				$html_input .= '<input type="hidden" id="ppom-meta-opt-index" value="' . esc_attr( $opt_index0 ) . '">';
				$html_input .= '<ul/>';

				break;

			case 'paired-palettes';
			case 'paired-pricematrix':
				$plc_option = ( ! empty( $placeholders ) ) ? $placeholders[0] : __( 'Option', 'woocommerce-product-addon' );
				$plc_price  = ( ! empty( $placeholders ) ) ? $placeholders[1] : __( 'Price (optional)', 'woocommerce-product-addon' );
				$plc_label  = ( ! empty( $placeholders ) ) ? $placeholders[2] : __( 'Label', 'woocommerce-product-addon' );
				$plc_id     = ( isset( $placeholders[3] ) && ! empty( $placeholders ) ) ? $placeholders[3] : __( 'Unique Option ID)', 'woocommerce-product-addon' );

				$opt_index0  = 1;
				$html_input .= '<ul class="ppom-options-container ppom-options-sortable ' . $type . '">';

				if ( $values ) {
					// ppom_pa($values);
					$last_array_id = max( array_keys( $values ) );

					foreach ( $values as $opt_index => $option ) {

						$label   = isset( $option['label'] ) ? $option['label'] : '';
						$isfixed = isset( $option['isfixed'] ) ? $option['isfixed'] : '';

						$option_id   = ppom_get_option_id( $option );
						$html_input .= '<li class="data-options ppom-sortable-handle" style="display: flex;">';
						$html_input .= '<span class="dashicons dashicons-move"></span>';
						$html_input .= '<input type="text" class="option-title form-control ppom-option-keys" name="ppom[' . esc_attr( $field_index ) . '][options][' . esc_attr( $opt_index ) . '][option]" value="' . esc_attr( stripslashes( $option['option'] ) ) . '" placeholder="' . $plc_option . '" data-metatype="option" data-opt-index="' . esc_attr( $opt_index ) . '">';
						$html_input .= '<input type="text" class="option-price form-control ppom-option-keys" name="ppom[' . esc_attr( $field_index ) . '][options][' . esc_attr( $opt_index ) . '][price]" value="' . esc_attr( $option['price'] ) . '" placeholder="' . $plc_price . '" data-metatype="price" data-opt-index="' . esc_attr( $opt_index ) . '">';
						$html_input .= '<input type="text" class="option-label form-control ppom-option-keys" name="ppom[' . esc_attr( $field_index ) . '][options][' . esc_attr( $opt_index ) . '][label]" value="' . esc_attr( $label ) . '" placeholder="' . $plc_label . '" data-metatype="label" data-opt-index="' . esc_attr( $opt_index ) . '">';
						$html_input .= '<input type="text" class="option-id form-control ppom-option-keys" name="ppom[' . esc_attr( $field_index ) . '][options][' . esc_attr( $opt_index ) . '][id]" value="' . esc_attr( $option_id ) . '" placeholder="' . $plc_id . '" data-metatype="id" data-opt-index="' . esc_attr( $opt_index ) . '">';
						$html_input .= '<label for=""><input type="checkbox" class="option-isfixed ppom-option-keys" name="ppom[' . esc_attr( $field_index ) . '][options][' . esc_attr( $opt_index ) . '][isfixed]" data-metatype="isfixed" ' . checked( $isfixed, 'on', false ) . ' data-opt-index="' . esc_attr( $opt_index ) . '">' . __( 'Fixed?', 'woocommerce-product-addon' ) . '</labe>';

						$html_input .= '<button class="btn btn-success ppom-add-option" data-option-type="paired"><i class="fa fa-plus" aria-hidden="true"></i></button>';
						$html_input .= '<button class="btn btn-danger ppom-remove-option"><i class="fa fa-minus" aria-hidden="true"></i></button>';

						$html_input .= '</li>';

						$opt_index0 = $last_array_id;
						$opt_index0 ++;

					}
				} else {
					$html_input .= '<li class="data-options" style="display: flex;">';
					$html_input .= '<span class="dashicons dashicons-move"></span>';
					$html_input .= '<input type="text" class="option-title form-control ppom-option-keys" placeholder="' . $plc_option . '" data-metatype="option">';
					$html_input .= '<input type="text" class="option-price form-control ppom-option-keys" placeholder="' . $plc_price . '" data-metatype="price">';

					$html_input .= '<input type="text" class="option-label form-control ppom-option-keys" placeholder="' . $plc_label . '" data-metatype="label">';

					$html_input .= '<input type="text" class="option-id form-control ppom-option-keys" placeholder="' . $plc_id . '" data-metatype="id">';

					$html_input .= '<label for=""><input type="checkbox" class="option-isfixed ppom-option-keys" data-metatype="isfixed">' . __( 'Fixed?', 'woocommerce-product-addon' ) . '</labe>';

					$html_input .= '<button class="btn btn-success ppom-add-option" data-option-type="paired"><i class="fa fa-plus" aria-hidden="true"></i></button>';
					$html_input .= '<button class="btn btn-danger ppom-remove-option"><i class="fa fa-minus" aria-hidden="true"></i></button>';

					$html_input .= '</li>';
				}
				$html_input .= '<input type="hidden" id="ppom-meta-opt-index" value="' . esc_attr( $opt_index0 ) . '">';
				$html_input .= '<ul/>';

				break;


			case 'font_paired':
				$plc_option = ( ! empty( $placeholders ) ) ? $placeholders[0] : __( 'Data Name', 'woocommerce-product-addon' );
				$plc_price  = ( ! empty( $placeholders ) ) ? $placeholders[1] : __( 'Font Name', 'woocommerce-product-addon' );

				$opt_index0  = 1;
				$html_input .= '<ul class="ppom-options-container ppom-options-sortable">';

				if ( $values ) {
					$last_array_id = max( array_keys( $values ) );

					foreach ( $values as $opt_index => $option ) {

						$weight = isset( $option['weight'] ) ? $option['weight'] : '';

						$html_input .= '<li class="data-options ppom-sortable-handle" style="display: flex;">';
						$html_input .= '<span class="dashicons dashicons-move"></span>';
						$html_input .= '<input type="text" class="option-title form-control ppom-option-keys" name="ppom[' . esc_attr( $field_index ) . '][options][' . esc_attr( $opt_index ) . '][dataname]" value="' . esc_attr( stripslashes( $option['dataname'] ) ) . '" placeholder="' . $plc_option . '" data-metatype="dataname" data-opt-index="' . esc_attr( $opt_index ) . '">';
						$html_input .= '<input type="text" class="form-control ppom-option-keys" name="ppom[' . esc_attr( $field_index ) . '][options][' . esc_attr( $opt_index ) . '][font_name]" value="' . esc_attr( $option['font_name'] ) . '" placeholder="' . $plc_price . '" data-metatype="font_name" data-opt-index="' . esc_attr( $opt_index ) . '">';


						$html_input .= '<button class="btn btn-success ppom-add-option" data-option-type="paired"><i class="fa fa-plus" aria-hidden="true"></i></button>';
						$html_input .= '</li>';

						$opt_index0 = $last_array_id;
						$opt_index0 ++;

					}
				} else {
					$html_input .= '<li class="data-options" style="display: flex;">';
					$html_input .= '<span class="dashicons dashicons-move"></span>';
					$html_input .= '<input type="text" class="option-title form-control ppom-option-keys" placeholder="' . $plc_option . '" data-metatype="dataname">';
					$html_input .= '<input type="text" class="form-control ppom-option-keys" placeholder="' . $plc_price . '" data-metatype="font_name">';

					$html_input .= '<button class="btn btn-success ppom-add-option" data-option-type="paired"><i class="fa fa-plus" aria-hidden="true"></i></button>';
					$html_input .= '</li>';
				}
				$html_input .= '<input type="hidden" id="ppom-meta-opt-index" value="' . esc_attr( $opt_index0 ) . '">';
				$html_input .= '<ul/>';

				break;

			case 'paired-quantity':
				$opt_index0  = 1;
				$html_input .= '<ul class="ppom-options-container">';

				if ( $values ) {

					$last_array_id = max( array_keys( $values ) );

					foreach ( $values as $opt_index => $option ) {

						$weight  = isset( $option['weight'] ) ? $option['weight'] : '';
						$stock   = isset( $option['stock'] ) ? $option['stock'] : '';
						$default = isset( $option['default'] ) ? $option['default'] : '';

						$html_input .= '<li class="data-options" style="display: flex;">';
						$html_input .= '<span class="dashicons dashicons-move"></span>';
						$html_input .= '<input type="text" class="form-control ppom-option-keys" name="ppom[' . esc_attr( $field_index ) . '][options][' . esc_attr( $opt_index ) . '][option]" value="' . esc_attr( stripslashes( $option['option'] ) ) . '" placeholder="' . __( 'option', 'woocommerce-product-addon' ) . '" data-metatype="option" data-opt-index="' . esc_attr( $opt_index ) . '">';
						$html_input .= '<input type="text" class="form-control ppom-option-keys" name="ppom[' . esc_attr( $field_index ) . '][options][' . esc_attr( $opt_index ) . '][price]" value="' . esc_attr( $option['price'] ) . '" placeholder="' . __( 'price (if any)', 'woocommerce-product-addon' ) . '" data-metatype="price" data-opt-index="' . esc_attr( $opt_index ) . '">';
						$html_input .= '<input type="text" class="form-control ppom-option-keys" name="ppom[' . esc_attr( $field_index ) . '][options][' . esc_attr( $opt_index ) . '][weight]" value="' . esc_attr( $weight ) . '" placeholder="' . __( 'weight (if any)', 'woocommerce-product-addon' ) . '" data-metatype="weight" data-opt-index="' . esc_attr( $opt_index ) . '">';
						$html_input .= '<input type="text" class="form-control ppom-option-keys" name="ppom[' . esc_attr( $field_index ) . '][options][' . esc_attr( $opt_index ) . '][default]" value="' . esc_attr( $default ) . '" placeholder="' . __( 'Default. Qty', 'woocommerce-product-addon' ) . '" data-metatype="default" data-opt-index="' . esc_attr( $opt_index ) . '">';
						$html_input .= '<input type="text" class="form-control ppom-option-keys" name="ppom[' . esc_attr( $field_index ) . '][options][' . esc_attr( $opt_index ) . '][min]" value="' . esc_attr( $option['min'] ) . '" placeholder="' . __( 'Min. Qty', 'woocommerce-product-addon' ) . '" data-metatype="min" data-opt-index="' . esc_attr( $opt_index ) . '">';
						$html_input .= '<input type="text" class="form-control ppom-option-keys" name="ppom[' . esc_attr( $field_index ) . '][options][' . esc_attr( $opt_index ) . '][max]" value="' . esc_attr( $option['max'] ) . '" placeholder="' . __( 'Max. Qty', 'woocommerce-product-addon' ) . '" data-metatype="max" data-opt-index="' . esc_attr( $opt_index ) . '">';
						$html_input .= '<input type="text" class="form-control ppom-option-keys" name="ppom[' . esc_attr( $field_index ) . '][options][' . esc_attr( $opt_index ) . '][stock]" value="' . esc_attr( $stock ) . '" placeholder="' . __( 'Stock', 'woocommerce-product-addon' ) . '" data-metatype="stock" data-opt-index="' . esc_attr( $opt_index ) . '">';

						$html_input .= '<button class="btn btn-success ppom-add-option" data-option-type="paired-quantity"><i class="fa fa-plus" aria-hidden="true"></i></button>';
						$html_input .= '<button class="btn btn-danger ppom-remove-option"><i class="fa fa-minus" aria-hidden="true"></i></button>';

						$html_input .= '</li>';

						$opt_index0 = $last_array_id;
						$opt_index0 ++;
					}
				} else {
					$html_input .= '<li class="data-options" style="display: flex;">';
					$html_input .= '<span class="dashicons dashicons-move"></span>';
					$html_input .= '<input type="text" class="form-control ppom-option-keys" placeholder="' . __( 'option', 'woocommerce-product-addon' ) . '" data-metatype="option">';
					$html_input .= '<input type="text" class="form-control ppom-option-keys" placeholder="' . __( 'price (if any)', 'woocommerce-product-addon' ) . '" data-metatype="price">';
					$html_input .= '<input type="text" class="form-control ppom-option-keys" placeholder="' . __( 'weight (if any)', 'woocommerce-product-addon' ) . '" data-metatype="weight">';
					$html_input .= '<input type="text" class="form-control ppom-option-keys" placeholder="' . __( 'Default. Qty', 'woocommerce-product-addon' ) . '" data-metatype="default">';
					$html_input .= '<input type="text" class="form-control ppom-option-keys" placeholder="' . __( 'Min. Qty', 'woocommerce-product-addon' ) . '" data-metatype="min">';
					$html_input .= '<input type="text" class="form-control ppom-option-keys" placeholder="' . __( 'Max. Qty', 'woocommerce-product-addon' ) . '" data-metatype="max">';
					$html_input .= '<input type="text" class="form-control ppom-option-keys" placeholder="' . __( 'Stock', 'woocommerce-product-addon' ) . '" data-metatype="stock">';

					$html_input .= '<button class="btn btn-success ppom-add-option" data-option-type="paired-quantity"><i class="fa fa-plus" aria-hidden="true"></i></button>';
					$html_input .= '<button class="btn btn-danger ppom-remove-option"><i class="fa fa-minus" aria-hidden="true"></i></button>';

					$html_input .= '</li>';
				}

				$html_input .= '<input type="hidden" id="ppom-meta-opt-index" value="' . esc_attr( $opt_index0 ) . '">';
				$html_input .= '<ul/>';

				break;

			case 'paired-measure':
				$html_input .= '<ul class="ppom-options-container">';

				$add_option_img = $plugin_meta['url'] . '/images/plus.png';
				$del_option_img = $plugin_meta['url'] . '/images/minus.png';
				$plc_id         = ( ! empty( $placeholders ) ) ? $placeholders[2] : __( 'Unique ID)', 'woocommerce-product-addon' );

				if ( $value ) {
					foreach ( $value as $option ) {

						$option_id = ppom_get_option_id( $option );

						$html_input .= '<li class="data-options">';
						$html_input .= '<span class="dashicons dashicons-move"></span>';
						$html_input .= '<input type="text" name="options[option]" value="' . esc_attr( stripslashes( $option['option'] ) ) . '" placeholder="' . __( 'Unit', 'woocommerce-product-addon' ) . '">';
						$html_input .= '<input type="text" name="options[price]" value="' . esc_attr( $option['price'] ) . '" placeholder="' . __( 'price (if any)', 'woocommerce-product-addon' ) . '">';
						$html_input .= '<input type="text" class="option-id" name="options[id]" value="' . esc_attr( $option_id ) . '" placeholder="' . $plc_id . '">';
						$html_input .= '<img class="add_option" src="' . esc_url( $add_option_img ) . '" title="add rule" alt="add rule" style="cursor:pointer; margin:0 3px;">';
						$html_input .= '<img class="remove_option" src="' . esc_url( $del_option_img ) . '" title="remove rule" alt="remove rule" style="cursor:pointer; margin:0 3px;">';
						$html_input .= '</li>';
					}
				} else {
					$html_input .= '<li class="data-options">';
					$html_input .= '<span class="dashicons dashicons-move"></span>';
					$html_input .= '<input type="text" name="options[option]" placeholder="' . __( 'Unit', 'woocommerce-product-addon' ) . '">';
					$html_input .= '<input type="text" name="options[price]" placeholder="' . __( 'price (if any)', 'woocommerce-product-addon' ) . '">';
					$html_input .= '<input type="text" class="option-id" name="options[id]" placeholder="' . $plc_id . '">';
					$html_input .= '<img class="add_option" src="' . esc_url( $add_option_img ) . '" title="add rule" alt="add rule" style="cursor:pointer; margin:0 3px;">';
					$html_input .= '<img class="remove_option" src="' . esc_url( $del_option_img ) . '" title="remove rule" alt="remove rule" style="cursor:pointer; margin:0 3px;">';
					$html_input .= '</li>';
				}

				$html_input .= '<ul/>';

				break;

			case 'paired-cropper':
				$opt_index0  = 1;
				$html_input .= '<ul class="ppom-options-container ppom-cropper-boundary">';

				if ( $values ) {
					// ppom_pa($values);
					$last_array_id = max( array_keys( $values ) );
					foreach ( $values as $opt_index => $option ) {

						$price = isset( $option['price'] ) ? $option['price'] : '';

						$html_input .= '<li class="data-options" style=display:flex;>';
						$html_input .= '<span class="dashicons dashicons-move"></span>';
						$html_input .= '<input type="text" name="ppom[' . esc_attr( $field_index ) . '][options][' . esc_attr( $opt_index ) . '][option]" value="' . esc_attr( stripslashes( $option['option'] ) ) . '" placeholder="' . __( 'Label', 'woocommerce-product-addon' ) . '" class="form-control ppom-option-keys" data-metatype="option" data-opt-index="' . esc_attr( $opt_index ) . '">';
						$html_input .= '<input type="text" name="ppom[' . esc_attr( $field_index ) . '][options][' . esc_attr( $opt_index ) . '][width]" value="' . esc_attr( stripslashes( $option['width'] ) ) . '" placeholder="' . __( 'Width', 'woocommerce-product-addon' ) . '" class="form-control ppom-option-keys" data-metatype="width" data-opt-index="' . esc_attr( $opt_index ) . '">';
						$html_input .= '<input type="text" name="ppom[' . esc_attr( $field_index ) . '][options][' . esc_attr( $opt_index ) . '][height]" value="' . esc_attr( $option['height'] ) . '" placeholder="' . __( 'Height', 'woocommerce-product-addon' ) . '" class="form-control ppom-option-keys" data-metatype="height" data-opt-index="' . esc_attr( $opt_index ) . '">';
						$html_input .= '<input type="text" name="ppom[' . esc_attr( $field_index ) . '][options][' . esc_attr( $opt_index ) . '][price]" value="' . esc_attr( $price ) . '" placeholder="' . __( 'Price (optional)', 'woocommerce-product-addon' ) . '" class="form-control ppom-option-keys" data-metatype="price" data-opt-index="' . esc_attr( $opt_index ) . '">';

						$html_input .= '<button class="btn btn-success ppom-add-option" data-option-type="paired-cropper"><i class="fa fa-plus" aria-hidden="true"></i></button>';
						$html_input .= '<button class="btn btn-danger ppom-remove-option"><i class="fa fa-minus" aria-hidden="true"></i></button>';

						$html_input .= '</li>';

						$opt_index0 = $last_array_id;
						$opt_index0 ++;
					}
				} else {
					$html_input .= '<li class="data-options" style=display:flex;>';
					$html_input .= '<span class="dashicons dashicons-move"></span>';
					$html_input .= '<input type="text" placeholder="' . __( 'option', 'woocommerce-product-addon' ) . '" class="form-control ppom-option-keys" data-metatype="option">';
					$html_input .= '<input type="text" placeholder="' . __( 'Width', 'woocommerce-product-addon' ) . '" class="form-control ppom-option-keys" data-metatype="width">';
					$html_input .= '<input type="text" placeholder="' . __( 'Height', 'woocommerce-product-addon' ) . '" class="form-control ppom-option-keys" data-metatype="height">';
					$html_input .= '<input type="text" placeholder="' . __( 'Price (optional)', 'woocommerce-product-addon' ) . '" class="form-control ppom-option-keys" data-metatype="price">';

					$html_input .= '<button class="btn btn-success ppom-add-option" data-option-type="paired-cropper"><i class="fa fa-plus" aria-hidden="true"></i></button>';
					$html_input .= '<button class="btn btn-danger ppom-remove-option"><i class="fa fa-minus" aria-hidden="true"></i></button>';

					$html_input .= '</li>';
				}
				$html_input .= '<input type="hidden" id="ppom-meta-opt-index" value="' . esc_attr( $opt_index0 ) . '">';
				$html_input .= '<ul/>';

				break;

			case 'checkbox':
				$disabled_attr = ( isset($data['disabled']) && $data['disabled'] === true ) ? 'disabled' : '';

				if ( $options ) {
					foreach ( $options as $key => $val ) {

						parse_str( $values, $saved_data );
						$checked = '';
						if ( isset( $saved_data ['editing_tools'] ) && $saved_data ['editing_tools'] ) {
							if ( in_array( $key, $saved_data['editing_tools'] ) ) {
								$checked = 'checked="checked"';
							} else {
								$checked = '';
							}
						}

						// For event Calendar Addon
						if ( isset( $saved_data ['cal_addon_disable_days'] ) && $saved_data ['cal_addon_disable_days'] ) {
							if ( in_array( $key, $saved_data['cal_addon_disable_days'] ) ) {
								$checked = 'checked="checked"';
							} else {
								$checked = '';
							}
						}
						// $html_input .= '<option value="' . $key . '" ' . $selected . '>' . $val . '</option>';
						$html_input .= '<label style="float:left;">';
						$html_input .= '<input type="checkbox" '.$disabled_attr.' value="' . $key . '" name="ppom[' . esc_attr( $field_index ) . '][' . esc_attr( $name ) . '][]" ' . $checked . '> ' . $val . '<br>';
						$html_input .= '<span></span>';
						$html_input .= '</label>';
					}
				} else {
					$checked = ( ( isset( $values ) && $values != '' ) ? 'checked = "checked"' : '' );

					$html_input .= '<label style="float:left;">';
					$html_input .= '<input type="checkbox" '.$disabled_attr.' class="ppom-meta-field" data-metatype="' . esc_attr( $name ) . '" ' . $checked . '';

					if ( $field_index != '' ) {

						$html_input .= $existing_name;
					}

					$html_input .= '>';

					$html_input .= '<span></span>';
					$html_input .= '</label>';

				}
				break;

			case 'html-conditions':
				$condition_index = 1;
				$rule_i          = 1;
				if ( $values ) {
					// ppom_pa($values);
					$condition_rules = isset( $values['rules'] ) ? $values['rules'] : array();
					$last_array_id   = max( array_keys( $condition_rules ) );

					$visibility_show = ( $values['visibility'] === 'Show' ) ? 'selected="selected"' : '';
					$visibility_hide = ( $values['visibility'] === 'Hide' ) ? 'selected="selected"' : '';
					$bound_all       = ( $values['bound'] === 'All' ) ? 'selected="selected"' : '';
					$bound_any       = ( $values['bound'] === 'Any' ) ? 'selected="selected"' : '';

					$html_input  = '<div class="row ppom-condition-style-wrap">';
					$html_input .= '<div class="col-md-3 col-sm-3">';
					$html_input .= '<select name="ppom[' . esc_attr( $field_index ) . '][conditions][visibility]" class="form-control ppom-condition-visible-bound" data-metatype="visibility">';
					$html_input .= '<option ' . $visibility_show . ' value="Show">' . __( 'Show', 'woocommerce-product-addon' ) . '</option>';
					$html_input .= '<option ' . $visibility_hide . ' value="Hide">' . __( 'Hide', 'woocommerce-product-addon' ) . '</option>';
					$html_input .= '</select>';
					$html_input .= '</div>';

					$html_input .= '<div>';
					$html_input .= '<p>' . __( 'only if', 'woocommerce-product-addon' ) . '</p>';
					$html_input .= '</div>';

					$html_input .= '<div class="col-md-3 col-sm-3">';
					$html_input .= '<select name="ppom[' . esc_attr( $field_index ) . '][conditions][bound]" class="form-control ppom-condition-visible-bound" data-metatype="bound">';
					$html_input .= '<option ' . $bound_all . ' value="All">' . __( 'All', 'woocommerce-product-addon' ) . '</option>';
					$html_input .= '<option ' . $bound_any . ' value="Any">' . __( 'Any', 'woocommerce-product-addon' ) . '</option>';
					$html_input .= '</select>';
					$html_input .= '</div>';

					$html_input .= '<div class="col-md-4 col-sm-4">';
					$html_input .= '<p>' . __( 'of the following matches', 'woocommerce-product-addon' ) . '</p>';
					$html_input .= '</div>';
					$html_input .= '</div>';

					$html_input .= '<div class="row ppom-condition-clone-js">';
					foreach ( $condition_rules as $rule_index => $condition ) {

						$element_values         = isset( $condition['element_values'] ) ? stripslashes( $condition['element_values'] ) : '';
						$element                = isset( $condition['elements'] ) ? stripslashes( $condition['elements'] ) : '';
						$element_constant_value = isset( $condition['element_constant'] ) ? stripslashes( $condition['element_constant'] ) : '';

						$element_between_value_to   = '';
						$element_between_value_from = '';

						if ( isset( $condition['cond-between-interval'] ) && is_array( $condition['cond-between-interval'] ) ) {
							$element_between_value_to   = isset( $condition['cond-between-interval']['to'] ) ? $condition['cond-between-interval']['to'] : '';
							$element_between_value_from = isset( $condition['cond-between-interval']['from'] ) ? $condition['cond-between-interval']['from'] : '';
						}

						$operator_is      = ( $condition['operators'] == 'is' ) ? 'selected="selected"' : '';
						$operator_not     = ( $condition['operators'] == 'not' ) ? 'selected="selected"' : '';
						$operator_greater = ( $condition['operators'] == 'greater than' ) ? 'selected="selected"' : '';
						$operator_less    = ( $condition['operators'] == 'less than' ) ? 'selected="selected"' : '';

						$html_input .= '<div class="webcontact-rules" id="rule-box-' . esc_attr( $rule_i ) . '">';
						$html_input .= '<div class="col-md-12 col-sm-12"><label>' . __( 'Rule', 'woocommerce-product-addon' ) . ' ' . $rule_i ++ . '</label></div>';

						// conditional elements
						$html_input .= '<div class="col-md-4 col-sm-4">';
						$html_input .= '<select name="ppom[' . esc_attr( $field_index ) . '][conditions][rules][' . esc_attr( $rule_index ) . '][elements]" class="form-control ppom-conditional-keys" data-metatype="elements"
										data-existingvalue="' . esc_attr( $element ) . '" >';
						$html_input .= '<option>' . $element . '</option>';
						$html_input .= '</select>';
						$html_input .= '</div>';

						// is value meta
						$pro_enabled = ppom_pro_is_installed() && 'valid' === apply_filters( 'product_ppom_license_status', '' );

						$html_input .= '<div class="col-md-3 col-sm-3">';
						$html_input .= '<select name="ppom[' . esc_attr( $field_index ) . '][conditions][rules][' . esc_attr( $rule_index ) . '][operators]" class="form-control ppom-conditional-keys" data-metatype="operators">';

						$html_input .= '<optgroup label="' . __( 'Value Comparison', 'woocommerce-product-addon' ) . '">';
						$html_input .= '<option ' . $operator_is . ' value="is">' . __( 'is', 'woocommerce-product-addon' ) . '</option>';
						$html_input .= '<option ' . $operator_not . ' value="not">' . __( 'is not', 'woocommerce-product-addon' ) . '</option>';
						$html_input .= '<option ' . selected( 'empty', $condition['operators'], false ) . ' value="empty">' . __( 'is empty', 'woocommerce-product-addon' ) . '</option>';
						$html_input .= '<option ' . selected( 'any', $condition['operators'], false ) . ' value="any">' . __( 'has any value', 'woocommerce-product-addon' ) . '</option>';
						$html_input .= '</optgroup>';

						$html_input .= '<optgroup label="' . __( 'Text Matching', 'woocommerce-product-addon' ) . '">';
						$html_input .= '<option ' . selected( 'contains', $condition['operators'], false ) . ' value="contains" ' . disabled( false, $pro_enabled, false ) . '>' . __( 'contains', 'woocommerce-product-addon' ) . ( ! $pro_enabled ? ' (' . __( 'PRO', 'woocommerce-product-addon' ) . ')' : '' ) . '</option>';
						$html_input .= '<option ' . selected( 'not-contains', $condition['operators'], false ) . ' value="not-contains" ' . disabled( false, $pro_enabled, false ) . '>' . __( 'does not contain', 'woocommerce-product-addon' ) . ( ! $pro_enabled ? ' (' . __( 'PRO', 'woocommerce-product-addon' ) . ')' : '' ) . '</option>';
						$html_input .= '<option ' . selected( 'regex', $condition['operators'], false ) . ' value="regex" ' . disabled( false, $pro_enabled, false ) . '>' . __( 'matches RegEx', 'woocommerce-product-addon' ) . ( ! $pro_enabled ? ' (' . __( 'PRO', 'woocommerce-product-addon' ) . ')' : '' ) . '</option>';
						$html_input .= '</optgroup>';

						$html_input .= '<optgroup label="' . __( 'Numeric Comparison', 'woocommerce-product-addon' ) . '">';
						$html_input .= '<option ' . $operator_greater . ' value="greater than">' . __( 'greater than', 'woocommerce-product-addon' ) . '</option>';
						$html_input .= '<option ' . $operator_less . ' value="less than">' . __( 'less than', 'woocommerce-product-addon' ) . '</option>';
						$html_input .= '<option ' . selected( 'between', $condition['operators'], false ) . ' value="between" ' . disabled( false, $pro_enabled, false ) . '>' . __( 'is between', 'woocommerce-product-addon' ) . ( ! $pro_enabled ? ' (' . __( 'PRO', 'woocommerce-product-addon' ) . ')' : '' ) . '</option>';
						$html_input .= '<option ' . selected( 'number-multiplier', $condition['operators'], false ) . ' value="number-multiplier" ' . disabled( false, $pro_enabled, false ) . '>' . __( 'is multiple of', 'woocommerce-product-addon' ) . ( ! $pro_enabled ? ' (' . __( 'PRO', 'woocommerce-product-addon' ) . ')' : '' ) . '</option>';
						$html_input .= '<option ' . selected( 'even-number', $condition['operators'], false ) . ' value="even-number" ' . disabled( false, $pro_enabled, false ) . '>' . __( 'is even', 'woocommerce-product-addon' ) . ( ! $pro_enabled ? ' (' . __( 'PRO', 'woocommerce-product-addon' ) . ')' : '' ) . '</option>';
						$html_input .= '<option ' . selected( 'odd-number', $condition['operators'], false ) . ' value="odd-number" ' . disabled( false, $pro_enabled, false ) . '>' . __( 'is odd', 'woocommerce-product-addon' ) . ( ! $pro_enabled ? ' (' . __( 'PRO', 'woocommerce-product-addon' ) . ')' : '' ) . '</option>';
						$html_input .= '</optgroup>';

						$html_input .= '</select> ';
						$html_input .= '</div>';

						// conditional elements values
						$html_input .= '<div class="col-md-3 col-sm-3">';

						$html_input .= '<select name="ppom[' . esc_attr( $field_index ) . '][conditions][rules][' . esc_attr( $rule_index ) . '][element_values]" class="form-control ppom-conditional-keys" data-metatype="element_values"
										data-existingvalue="' . esc_attr( $element_values ) . '" >';
						$html_input .= '<option>' . $element_values . '</option>';
						$html_input .= '</select>';
						$html_input .= '<input name="ppom[' . esc_attr( $field_index ) . '][conditions][rules][' . esc_attr( $rule_index ) . '][element_constant]" class="form-control ppom-conditional-keys ppom-hide-element" data-metatype="element_constant" value="' . esc_attr( $element_constant_value ) . '" >';

						$html_input .= '<div class="ppom-between-input-container ppom-hide-element"> ';
						$html_input .= '<input type="number" name="ppom[' . esc_attr( $field_index ) . '][conditions][rules][' . esc_attr( $rule_index ) . '][cond-between-interval][from]" class="form-control ppom-conditional-keys" data-metatype="between-input-from" value="' . esc_attr( $element_between_value_from ) . '" pattern="^\\d+(\\.\\d{1,4})?$">';
						$html_input .= '<span>' . __( 'and', 'woocommerce-product-addon' ) . '</span>';
						$html_input .= '<input type="number" name="ppom[' . esc_attr( $field_index ) . '][conditions][rules][' . esc_attr( $rule_index ) . '][cond-between-interval][to]" class="form-control ppom-conditional-keys" data-metatype="between-input-to" value="' . esc_attr( $element_between_value_to ) . '" pattern="^\\d+(\\.\\d{1,4})?$">';
						$html_input .= '</div>';

						// Upsell
						$html_input .= '<a class="ppom-upsell-condition ppom-hide-element" target="_blank" href="' . esc_url( tsdk_utmify( tsdk_translate_link( PPOM_UPGRADE_URL ), 'input-field-edit', 'condition' ) ) . '"><span class="dashicons dashicons-external"></span> ' . __('Upgrade to Unlock', 'woocommerce-product-addon') . '</a>';

						// $html_input .= '<input type="text" name="ppom['.esc_attr($field_index).'][conditions][rules]['.esc_attr($rule_index).'][element_values]" class="form-control ppom-conditional-keys" value="'.esc_attr($element_values).'" placeholder="Enter Option" data-metatype="element_values">';
						$html_input .= '</div>';

						// Add and remove btn
						$html_input .= '<div class="col-md-2 col-sm-2">';
						if ( $last_array_id === $rule_index ) {
							$html_input .= '<button class="btn btn-success ppom-add-rule" data-index="5"><i class="fa fa-plus" aria-hidden="true"></i></button>';
						}
						if ( $last_array_id > 0 ) {
							$html_input .= '<button class="btn btn-danger ppom-remove-rule ml-1" data-index="5"><i class="fa fa-minus" aria-hidden="true"></i></button>';
						}
						$html_input .= '</div>';
						$html_input .= '</div>';

						$condition_index = $last_array_id;
						$condition_index ++;
					}
					$html_input .= '</div>';
				} else {

					$html_input .= '<div class="row ppom-condition-style-wrap">';
					$html_input .= '<div class="col-md-4 col-sm-4">';
					$html_input .= '<select class="form-control ppom-condition-visible-bound" data-metatype="visibility">';
					$html_input .= '<option value="Show">' . __( 'Show', 'woocommerce-product-addon' ) . '</option>';
					$html_input .= '<option value="Hide">' . __( 'Hide', 'woocommerce-product-addon' ) . '</option>';
					$html_input .= '</select> ';
					$html_input .= '</div>';
					$html_input .= '<div>';
					$html_input .= '<p>' . __( 'only if', 'woocommerce-product-addon' ) . '</p>';
					$html_input .= '</div>';
					$html_input .= '<div class="col-md-3 col-sm-3">';
					$html_input .= '<select class="form-control ppom-condition-visible-bound" data-metatype="bound">';
					$html_input .= '<option value="All">' . __( 'All', 'woocommerce-product-addon' ) . '</option>';
					$html_input .= '<option value="Any">' . __( 'Any', 'woocommerce-product-addon' ) . '</option>';
					$html_input .= '</select> ';
					$html_input .= '</div>';
					$html_input .= '<div class="col-md-4 col-sm-4">';
					$html_input .= '<p> ' . __( 'of the following matches', 'woocommerce-product-addon' ) . '</p>';
					$html_input .= '</div>';
					$html_input .= '</div>';

					$html_input .= '<div class="row ppom-condition-clone-js">';
					$html_input .= '<div class="webcontact-rules" id="rule-box-' . esc_attr( $rule_i ) . '">';
					$html_input .= '<div class="col-md-12 col-sm-12"><label>' . __( 'Rule', 'woocommerce-product-addon' ) . ' ' . $rule_i ++ . '</label></div>';

					// conditional elements
					$html_input .= '<div class="col-md-4 col-sm-4">';
					$html_input .= '<select data-metatype="elements" class="ppom-conditional-keys form-control"></select>';
					$html_input .= '</div>';

					// is
					$pro_enabled = ppom_pro_is_installed() && 'valid' === apply_filters( 'product_ppom_license_status', '' );

					$html_input .= '<div class="col-md-3 col-sm-3">';
					$html_input .= '<select name="ppom[' . esc_attr( $field_index ) . '][conditions][rules][0][operators]" class="form-control ppom-conditional-keys" data-metatype="operators">';

					$html_input .= '<optgroup label="' . __( 'Value Comparison', 'woocommerce-product-addon' ) . '">';
					$html_input .= '<option  value="is">' . __( 'is', 'woocommerce-product-addon' ) . '</option>';
					$html_input .= '<option  value="not">' . __( 'is not', 'woocommerce-product-addon' ) . '</option>';
					$html_input .= '<option  value="empty">' . __( 'is empty', 'woocommerce-product-addon' ) . '</option>';
					$html_input .= '<option value="any">' . __( 'has any value', 'woocommerce-product-addon' ) . '</option>';
					$html_input .= '</optgroup>';

					$html_input .= '<optgroup label="' . __( 'Text Matching', 'woocommerce-product-addon' ) . '">';
					$html_input .= '<option  value="contains" ' . disabled( false, $pro_enabled, false ) . '>' . __( 'contains', 'woocommerce-product-addon' ) . ( ! $pro_enabled ? ' (' . __( 'PRO', 'woocommerce-product-addon' ) . ')' : '' ) . '</option>';
					$html_input .= '<option  value="not-contains" ' . disabled( false, $pro_enabled, false ) . '>' . __( 'does not contain', 'woocommerce-product-addon' ) . ( ! $pro_enabled ? ' ' . __( 'PRO', 'woocommerce-product-addon' ) . ' ' : '' ) . '</option>';
					$html_input .= '<option  value="regex" ' . disabled( false, $pro_enabled, false ) . '>' . __( 'matches RegEx', 'woocommerce-product-addon' ) . ( ! $pro_enabled ? ' (' . __( 'PRO', 'woocommerce-product-addon' ) . ')' : '' ) . '</option>';
					$html_input .= '</optgroup>';

					$html_input .= '<optgroup label="' . __( 'Numeric Comparison', 'woocommerce-product-addon' ) . '">';
					$html_input .= '<option   value="greater than">' . __( 'greater than', 'woocommerce-product-addon' ) . '</option>';
					$html_input .= '<option   value="less than">' . __( 'less than', 'woocommerce-product-addon' ) . '</option>';
					$html_input .= '<option   value="between" ' . disabled( false, $pro_enabled, false ) . '>' . __( 'is between', 'woocommerce-product-addon' ) . ( ! $pro_enabled ? ' (' . __( 'PRO', 'woocommerce-product-addon' ) . ')' : '' ) . '</option>';
					$html_input .= '<option  value="number-multiplier" ' . disabled( false, $pro_enabled, false ) . '>' . __( 'is multiple of', 'woocommerce-product-addon' ) . ( ! $pro_enabled ? ' (' . __( 'PRO', 'woocommerce-product-addon' ) . ')' : '' ) . '</option>';
					$html_input .= '<option   value="even-number" ' . disabled( false, $pro_enabled, false ) . '>' . __( 'is even', 'woocommerce-product-addon' ) . ( ! $pro_enabled ? ' (' . __( 'PRO', 'woocommerce-product-addon' ) . ')' : '' ) . '</option>';
					$html_input .= '<option  value="odd-number" ' . disabled( false, $pro_enabled, false ) . '>' . __( 'is odd', 'woocommerce-product-addon' ) . ( ! $pro_enabled ? ' (' . __( 'PRO', 'woocommerce-product-addon' ) . ') ' : '' ) . '</option>';
					$html_input .= '</optgroup>';

					$html_input .= '</select> ';

					$html_input .= '</div>';

					$html_input .= '<div class="col-md-3 col-sm-3">';
					$html_input .= '<select name="ppom[' . esc_attr( $field_index ) . '][conditions][rules][0][element_values]" class="form-control ppom-conditional-keys ppom-hide-element" data-metatype="element_values">';
					$html_input .= '</select>';
					$html_input .= '<input name="ppom[' . esc_attr( $field_index ) . '][conditions][rules][0][element_constant]" class="form-control ppom-conditional-keys ppom-hide-element" data-metatype="element_constant"  >';

					$html_input .= '<div class="ppom-between-input-container ppom-hide-element"> ';
					$html_input .= '<input type="number" name="ppom[' . esc_attr( $field_index ) . '][conditions][rules][0][cond-between-interval][from]" class="form-control ppom-conditional-keys" data-metatype="between-input-from"  pattern="^\\d+(\\.\\d{1,4})?$">';
					$html_input .= '<span>' . __( 'and', 'woocommerce-product-addon' ) . '</span>';
					$html_input .= '<input type="number" name="ppom[' . esc_attr( $field_index ) . '][conditions][rules][0][cond-between-interval][to]" class="form-control ppom-conditional-keys" data-metatype="between-input-to" pattern="^\\d+(\\.\\d{1,4})?$">';
					$html_input .= '</div>';

					// Upsell
					$html_input .= '<a class="ppom-upsell-condition ppom-hide-element" target="_blank" href="' . esc_url( tsdk_utmify( tsdk_translate_link( PPOM_UPGRADE_URL ), 'input-field-edit', 'condition' ) ) . '"><span class="dashicons dashicons-external"></span> ' . __('Upgrade to Unlock', 'woocommerce-product-addon') . '</a>';


					$html_input .= '</div>';

					// Add and remove btn
					$html_input .= '<div class="col-md-2 col-sm-2">';
					$html_input .= '<button class="btn btn-success ppom-add-rule" data-index="5"><i class="fa fa-plus" aria-hidden="true"></i></button>';
					$html_input .= '</div>';

					$html_input .= '</div>';
					$html_input .= '</div>';
				}
				$html_input .= '<input type="hidden" class="ppom-condition-last-id" value="' . esc_attr( $condition_index ) . '">';

				break;

			case 'pre-images':
				$html_input .= '<div class="pre-upload-box table-responsive">';

				$html_input .= '<button class="btn btn-info ppom-pre-upload-image-btn" data-metatype="images">' . __( 'Select/Upload Image', 'woocommerce-product-addon' ) . '</button>';
				// ppom_pa($value);

				$opt_index0  = 0;
				$html_input .= '<ul class="ppom-options-container">';
				if ( $values ) {

					$last_array_id = max( array_keys( $values ) );

					foreach ( $values as $opt_index => $pre_uploaded_image ) {

						$image_link  = ( isset( $pre_uploaded_image['link'] ) ? $pre_uploaded_image['link'] : '' );
						$image_id    = ( isset( $pre_uploaded_image['id'] ) ? $pre_uploaded_image['id'] : '' );
						$image_url   = ( isset( $pre_uploaded_image['url'] ) ? $pre_uploaded_image['url'] : '' );
						$image_stock = ( isset( $pre_uploaded_image['stock'] ) ? $pre_uploaded_image['stock'] : '' );

						$image_name = isset( $pre_uploaded_image['link'] ) ? basename( $pre_uploaded_image['link'] ) : '';

						$html_input .= '<li class="data-options" data-condition-type="image_options">';
						$html_input .= '<span class="dashicons dashicons-move" style="margin-bottom: 7px;margin-top: 2px;"></span>';
						$html_input .= '<span class="ppom-uploader-img-title">' . $image_name . '</span>';
						$html_input .= '<div style="display: flex;">';
						$html_input .= '<div class="ppom-uploader-img-center">';
						$html_input .= '<img width="60" src="' . esc_url( $image_link ) . '" style="width: 34px;">';
						$html_input .= '</div>';
						$html_input .= '<input type="hidden" name="ppom[' . esc_attr( $field_index ) . '][images][' . esc_attr( $opt_index ) . '][link]" value="' . esc_url( $image_link ) . '" data-opt-index="' . esc_attr( $opt_index ) . '" data-metatype="link">';
						$html_input .= '<input type="hidden" name="ppom[' . esc_attr( $field_index ) . '][images][' . esc_attr( $opt_index ) . '][id]" value="' . esc_attr( $image_id ) . '" data-opt-index="' . esc_attr( $opt_index ) . '" data-metatype="id">';
						$html_input .= '<input class="form-control ppom-image-option-title" type="text" placeholder="Title" value="' . esc_attr( stripslashes( $pre_uploaded_image['title'] ) ) . '" name="ppom[' . esc_attr( $field_index ) . '][images][' . esc_attr( $opt_index ) . '][title]" data-opt-index="' . esc_attr( $opt_index ) . '" data-metatype="title">';
						$html_input .= '<input class="form-control" type="text" placeholder="Price (fix or %)" value="' . esc_attr( stripslashes( $pre_uploaded_image['price'] ) ) . '" name="ppom[' . esc_attr( $field_index ) . '][images][' . esc_attr( $opt_index ) . '][price]" data-opt-index="' . esc_attr( $opt_index ) . '" data-metatype="price">';
						$html_input .= '<input class="form-control" type="text" placeholder="Stock" value="' . esc_attr( $image_stock ) . '" name="ppom[' . esc_attr( $field_index ) . '][images][' . esc_attr( $opt_index ) . '][stock]" data-opt-index="' . esc_attr( $opt_index ) . '" data-metatype="stock">';
						$html_input .= '<input class="form-control" type="text" placeholder="URL" value="' . esc_url( stripslashes( $image_url  ) ) . '" name="ppom[' . esc_attr( $field_index ) . '][images][' . esc_attr( $opt_index ) . '][url]" data-opt-index="' . esc_attr( $opt_index ) . '" data-metatype="url">';

						$html_input .= '<button class="btn btn-danger ppom-pre-upload-delete" style="height: 35px;"><i class="fa fa-times" aria-hidden="true"></i></button>';
						$html_input .= '</div>';
						$html_input .= '</li>';

						$opt_index0 = $last_array_id;
						$opt_index0 ++;
					}
				}
				$html_input .= '</ul>';
				$html_input .= '<input type="hidden" id="ppom-meta-opt-index" value="' . esc_attr( $opt_index0 ) . '">';

				$html_input .= '</div>';

				break;

			case 'imageselect':
				$html_input .= '<div class="pre-upload-box table-responsive">';

				$html_input .= '<button class="btn btn-info ppom-pre-upload-image-btn" data-metatype="imageselect">' . __( 'Select/Upload Image', 'woocommerce-product-addon' ) . '</button>';

				$opt_index0  = 0;
				$html_input .= '<ul class="ppom-options-container">';
				if ( $values && is_array( $values ) ) {

					$last_array_id = max( array_keys( $values ) );

					foreach ( $values as $opt_index => $pre_uploaded_image ) {

						$image_link        = ( isset( $pre_uploaded_image['link'] ) ? $pre_uploaded_image['link'] : '' );
						$image_id          = ( isset( $pre_uploaded_image['id'] ) ? $pre_uploaded_image['id'] : '' );
						$image_description = ( isset( $pre_uploaded_image['description'] ) ? $pre_uploaded_image['description'] : '' );

						$image_name = isset( $pre_uploaded_image['link'] ) ? basename( $pre_uploaded_image['link'] ) : '';

						$html_input .= '<li class="data-options" data-condition-type="image_options">';
						$html_input .= '<span class="dashicons dashicons-move" style="margin-bottom: 7px;margin-top: 2px;"></span>';
						$html_input .= '<span class="ppom-uploader-img-title">' . $image_name . '</span>';
						$html_input .= '<div style="display: flex;">';
						$html_input .= '<div class="ppom-uploader-img-center">';
						$html_input .= '<img width="60" src="' . esc_url( $image_link ) . '" style="width: 34px;">';
						$html_input .= '</div>';
						$html_input .= '<input type="hidden" name="ppom[' . esc_attr( $field_index ) . '][images][' . esc_attr( $opt_index ) . '][link]" value="' . esc_url( $image_link ) . '" data-opt-index="' . esc_attr( $opt_index ) . '" data-metatype="link">';
						$html_input .= '<input type="hidden" name="ppom[' . esc_attr( $field_index ) . '][images][' . esc_attr( $opt_index ) . '][id]" value="' . esc_attr( $image_id ) . '" data-opt-index="' . esc_attr( $opt_index ) . '" data-metatype="id">';
						$html_input .= '<input class="form-control ppom-image-option-title" type="text" placeholder="Title" value="' . esc_attr( stripslashes( $pre_uploaded_image['title'] ) ) . '" name="ppom[' . esc_attr( $field_index ) . '][images][' . esc_attr( $opt_index ) . '][title]" data-opt-index="' . esc_attr( $opt_index ) . '" data-metatype="title">';
						$html_input .= '<input class="form-control" type="text" placeholder="Price" value="' . esc_attr( stripslashes( $pre_uploaded_image['price'] ) ) . '" name="ppom[' . esc_attr( $field_index ) . '][images][' . esc_attr( $opt_index ) . '][price]" data-opt-index="' . esc_attr( $opt_index ) . '" data-metatype="price">';
						$html_input .= '<input class="form-control" type="text" placeholder="Description" value="' . esc_attr( $image_description ) . '" name="ppom[' . esc_attr( $field_index ) . '][images][' . esc_attr( $opt_index ) . '][description]" data-opt-index="' . esc_attr( $opt_index ) . '" data-metatype="description">';
						$html_input .= '<button class="btn btn-danger ppom-pre-upload-delete" style="height: 35px;"><i class="fa fa-times" aria-hidden="true"></i></button>';
						$html_input .= '</div>';
						$html_input .= '</li>';

						$opt_index0 = $last_array_id;
						$opt_index0 ++;
					}
				}
				$html_input .= '</ul>';
				$html_input .= '<input type="hidden" id="ppom-meta-opt-index" value="' . esc_attr( $opt_index0 ) . '">';

				$html_input .= '</div>';

				break;

			case 'pre-audios':
				$html_input .= '<div class="pre-upload-box">';
				$html_input .= '<button class="btn btn-info ppom-pre-upload-image-btn" data-metatype="audio">' . __( 'Select Audio/Video', 'woocommerce-product-addon' ) . '</button>';

				$html_input .= '<ul class="ppom-options-container">';
				$opt_index0  = 0;
				// ppom_pa($values);
				if ( $values ) {
					$last_array_id = max( array_keys( $values ) );
					foreach ( $values as $opt_index => $pre_uploaded_image ) {

						$image_link  = ( isset( $pre_uploaded_image['link'] ) ? $pre_uploaded_image['link'] : '' );
						$image_id    = ( isset( $pre_uploaded_image['id'] ) ? $pre_uploaded_image['id'] : '' );
						$image_url   = ( isset( $pre_uploaded_image['url'] ) ? $pre_uploaded_image['url'] : '' );
						$media_title = ( isset( $pre_uploaded_image['title'] ) ? stripslashes( $pre_uploaded_image['title'] ) : '' );
						$media_price = ( isset( $pre_uploaded_image['price'] ) ? stripslashes( $pre_uploaded_image['price'] ) : '' );

						$html_input .= '<li class="data-options">';
						$html_input .= '<span class="dashicons dashicons-move" style="margin-bottom: 7px;margin-top: 2px;"></span>';
						$html_input .= '<div style="display: flex;">';
						$html_input .= '<div class="ppom-uploader-img-center">';
						$html_input .= '<span class="dashicons dashicons-admin-media" style="margin-top: 5px;"></span>';
						$html_input .= '</div>';
						$html_input .= '<input type="hidden" name="ppom[' . esc_attr( $field_index ) . '][audio][' . esc_attr( $opt_index ) . '][link]" value="' . esc_url( $image_link ) . '" data-opt-index="' . esc_attr( $opt_index ) . '" data-metatype="link">';
						$html_input .= '<input type="hidden" name="ppom[' . esc_attr( $field_index ) . '][audio][' . esc_attr( $opt_index ) . '][id]" value="' . esc_attr( $image_id ) . '" data-opt-index="' . esc_attr( $opt_index ) . '" data-metatype="id">';
						$html_input .= '<input class="form-control" type="text" placeholder="Title" value="' . esc_attr( $media_title ) . '" name="ppom[' . esc_attr( $field_index ) . '][audio][' . esc_attr( $opt_index ) . '][title]" data-opt-index="' . esc_attr( $opt_index ) . '" data-metatype="title">';
						$html_input .= '<input class="form-control" type="text" placeholder="Price (fix or %)" value="' . esc_attr( $media_price ) . '" name="ppom[' . esc_attr( $field_index ) . '][audio][' . esc_attr( $opt_index ) . '][price]" data-opt-index="' . esc_attr( $opt_index ) . '" data-metatype="price">';
						$html_input .= '<button class="btn btn-danger ppom-pre-upload-delete" style="height: 35px;"><i class="fa fa-times" aria-hidden="true"></i></button>';
						$html_input .= '</div>';
						$html_input .= '</li>';

						$opt_index0 = $last_array_id;
						$opt_index0 ++;

					}
				}
				$html_input .= '</ul>';
				$html_input .= '<input type="hidden" id="ppom-meta-opt-index" value="' . esc_attr( $opt_index0 ) . '">';
				$html_input .= '</div>';

				break;

			/**
			 * new addon: bulk quantity
			 *
			 * @since 7.1
			 */
			case 'bulk-quantity':
				$bulk_data = is_string( $values ) ? json_decode( $values, true ) : (array) $values;
				// ppom_pa($bulk_data[0]);
				$html_input .= '<div class="ppom-bulk-quantity-wrapper">';
				$html_input .= '<div class="table-content">';
				$html_input .= '<div class="ppom-bulk-action-wrap">';
				$html_input .= '<div class="ppom-bulkquantity-qty-wrap">';
				$html_input .= '<button class="btn btn-primary ppom-add-bulk-qty-row">Add Qty Range</button>';
				$html_input .= '<input type="text" class="ppom-bulk-qty-val form-control">';
				$html_input .= '</div>';
				$html_input .= '<div class="ppom-bulkquantity-variation-wrap">';
				$html_input .= '<button class="btn btn-primary ppom-add-bulk-variation-col">Add Variation</button>';
				$html_input .= '<input type="text" class="ppom-bulk-variation-val form-control">';
				$html_input .= '</div>';
				$html_input .= '</div>';
				$html_input .= '<div class="table-responsive">';
				$html_input .= '<table class="table">';
				$html_input .= '<thead>';
				$html_input .= '<tr>';

				if ( ! empty( $bulk_data ) ) {
					foreach ( $bulk_data[0] as $title => $value ) {
						$deleteIcon  = ( $title != 'Quantity Range' && $title != 'Base Price' ) ? '<span class="remove ppom-rm-bulk-variation"><i class="fa fa-times" aria-hidden="true"></i></span>' : '';
						$html_input .= '<th>' . $title . ' ' . $deleteIcon . '</th>';
					}
				} else {
					$html_input .= '<th>' . esc_html__( 'Quantity Range', 'woocommerce-product-addon' ) . '</th>';
					$html_input .= '<th>' . esc_html__( 'Base Price', 'woocommerce-product-addon' ) . '</th>';
				}

				$html_input .= '</tr>';
				$html_input .= '</thead>';
				$html_input .= '<tbody>';

				if ( ! empty( $bulk_data ) ) {
					foreach ( $bulk_data as $row => $data ) {
						$html_input .= '<tr>';
						foreach ( $data as $key => $value ) {
							if ( $key == 'Quantity Range' ) {
								$add_class = 'ppom-bulk-qty-val-picker form-control';
								$td_class  = 'ppom-bulkqty-adjust-cross';
							} else {
								$add_class = 'form-control';
								$td_class  = '';
							}
							$resetArr = reset( $data );
							$delRow   = ( $resetArr == $value ) ? '<span class="remove ppom-rm-bulk-qty"><i class="fa fa-times" aria-hidden="true"></i></span>' : '';
							if ( 1 ) {
								$html_input .= '<td class="' . $td_class . '" id="' . $td_class . '">' . $delRow . '<input type="text" class="' . $add_class . '" value="' . $value . '"></td>';
							}
						}
						$html_input .= '</tr>';
					}
				} else {
					$html_input .= '<tr>';
					$html_input .= '<td class="ppom-bulkqty-adjust-cross" id="ppom-bulkqty-adjust-cross">';
					$html_input .= '<span class="remove ppom-rm-bulk-qty"><i class="fa fa-times" aria-hidden="true"></i></span>';
					$html_input .= '<input type="text" class="form-control ppom-bulk-qty-val-picker" placeholder="1-10" />';
					$html_input .= '</td>';
					$html_input .= '<td><input type="text" class="form-control" /></td>';
					$html_input .= '</tr>';
				}

				$html_input .= '</tbody>';
				$html_input .= '</table>';
				$html_input .= '</div>';
				$html_input .= '<div class="text-right">';
				$html_input .= '<button class="btn btn-success ppom-save-bulk-json">'.esc_html__( 'Save Changing', 'woocommerce-product-addon' ).'</button> ';
				$html_input .= '<button class="btn btn-info ppom-edit-bulk-json">'.esc_html__( 'Edit Changing', 'woocommerce-product-addon' ).'</button>';

				if ( ! empty( $bulk_data ) ) {
					$html_input .= "<input type='hidden' name='ppom[" . esc_attr( $field_index ) . "][options]' class='ppom-saved-bulk-data ppom-meta-field' value='" . wp_json_encode( $bulk_data ) . "' data-metatype='options'>";
				} else {
					$html_input .= "<input type='hidden' class='ppom-saved-bulk-data ppom-meta-field' data-metatype='options'>";
				}


				$html_input .= '</div>';

				$html_input .= '</div>';
				$html_input .= '</div>';

				break;
		}

		return apply_filters( 'render_input_types', $html_input, $type, $name, $values, $options, $field_index );
	}


	function ppom_fields_tabs( $fields_type ) {

		$tabs = array();

		$tabs = array(
			'fields_tab'          => array(
				'label'        => __( 'Fields', 'woocommerce-product-addon' ),
				'class'        => array( 'ppom-tabs-label', 'ppom-active-tab' ),
				'field_depend' => array( 'all' ),
			),
			'condition_tab'       => array(
				'label'        => __( 'Conditions', 'woocommerce-product-addon' ),
				'class'        => array( 'ppom-tabs-label', 'ppom-condition-tab-js' ),
				'field_depend' => array( 'all' ),
				'not_allowed'  => array( 'hidden', 'koll' ),
			),
			'add_option_tab'      => array(
				'label'        => __( 'Add Options', 'woocommerce-product-addon' ),
				'class'        => array( 'ppom-tabs-label' ),
				'field_depend' => array(
					'select',
					'radio',
					'checkbox',
					'cropper',
					'cropper2',
					'quantities',
					'pricematrix',
					'palettes',
					'fixedprice',
					'bulkquantity',
				),
			),
			'add_images_tab'      => array(
				'label'        => __( 'Add Images', 'woocommerce-product-addon' ),
				'class'        => array( 'ppom-tabs-label' ),
				'field_depend' => array( 'image', 'imageselect' ),
			),
			'add_audio_video_tab' => array(
				'label'        => __( 'Add Audio/Video', 'woocommerce-product-addon' ),
				'class'        => array( 'ppom-tabs-label' ),
				'field_depend' => array( 'audio' ),
			),

			// Font Picker Addon tabs
			'fonts_family_tab'    => array(
				'label'        => __( 'Fonts Family', 'woocommerce-product-addon' ),
				'class'        => array( 'ppom-tabs-label' ),
				'field_depend' => array( 'fonts' ),
			),
			'custom_fonts_tab'    => array(
				'label'        => __( 'Custom Fonts', 'woocommerce-product-addon' ),
				'class'        => array( 'ppom-tabs-label' ),
				'field_depend' => array( 'fonts' ),
			),

			'image_dimension_tab' => array(
				'label'        => __( 'Image Dimensions', 'woocommerce-product-addon' ),
				'class'        => array( 'ppom-tabs-label' ),
				'field_depend' => array( 'file' ),
			),


		);

		return apply_filters( 'ppom_fields_tabs_show', $tabs, $fields_type );

	}

	/**
	 * Updates HTML classes of the given setting fields.
	 *
	 * @param  array $settings
	 * @return array Returns setting fields as updated their HTML classes.
	 */
	function update_html_classes( $settings ) {

		foreach ( $settings as $fields_meta_key => $meta ) {

			$type = isset( $meta['type'] ) ? $meta['type'] : '';

			if ( $type == 'html-conditions' ) {

				$settings['conditions']['tabs_class'] = array( 'ppom_handle_condition_tab', 'col-md-12' );
			} elseif ( $type == 'paired' || $type == 'paired-cropper'
						|| $type == 'paired-quantity' ||
						$type == 'paired-pricematrix' ||
						$type == 'bulk-quantity' || $type == 'paired-palettes' ) {
				// Bulk Quantity Addon Tabs
				// Fixed Price Addon Tabs

				$settings['options']['tabs_class'] = array( 'ppom_handle_add_option_tab', 'col-md-12' );
			} elseif ( $type == 'pre-images' || $type == 'imageselect' ) { // Image DropDown Addon Tabs

				$settings['images']['tabs_class'] = array( 'ppom_handle_add_images_tab', 'col-md-12' );
			} elseif ( $type == 'pre-audios' ) {

				$settings['audio']['tabs_class'] = array( 'ppom_handle_add_audio_video_tab', 'col-md-12' );
			} elseif ( $fields_meta_key == 'logic' ) {

				$settings['logic']['tabs_class'] = array( 'ppom_handle_condition_tab', 'col-md-12' );
			}

			// Fonts Picker Addon tabs
			if ( $fields_meta_key == 'fonts' ) {
				$settings['fonts']['tabs_class'] = array( 'ppom_handle_fonts_family_tab', 'col-md-12' );
			} elseif ( $fields_meta_key == 'custom_fonts' ) {
				$settings['custom_fonts']['tabs_class'] = array( 'ppom_handle_custom_fonts_tab', 'col-md-12' );
			}

			// Image Dimensions Options (File Input)
			if ( $fields_meta_key == 'min_img_h' ) {
				$settings['min_img_h']['tabs_class']           = array( 'ppom_handle_image_dimension_tab', 'col-md-6' );
				$settings['max_img_h']['tabs_class']           = array( 'ppom_handle_image_dimension_tab', 'col-md-6' );
				$settings['min_img_w']['tabs_class']           = array( 'ppom_handle_image_dimension_tab', 'col-md-6' );
				$settings['max_img_w']['tabs_class']           = array( 'ppom_handle_image_dimension_tab', 'col-md-6' );
				$settings['img_dimension_error']['tabs_class'] = array( 'ppom_handle_image_dimension_tab', 'col-md-6' );
			}       
		}

		// ppom_pa
		return apply_filters( 'ppom_tabs_panel_classes', $settings );
	}

}

PPOM_FIELDS_META();
function PPOM_FIELDS_META() {
	return PPOM_Fields_Meta::get_instance();
}
